<?php


use FwAuthSystem\Main\UserObject;
use FwHtml\FontAwesome as Fa;

$SideBar = new Sidebar(true);

$SideBar->Item('اطلاعات جغرافیایی', Fa::Location_arrow())->_items([
    MenuItem::create('استان ها', Fa::Location_arrow())->LinksTo(\controller\States::class),
    MenuItem::create('شهر ها', Fa::Location_arrow())->LinksTo(\controller\Cities::class),
    MenuItem::create('مناطق', Fa::Location_arrow())->LinksTo(\controller\Regions::class),
]);
$SideBar->Item('اصناف', Fa::Shopping_cart())->LinksTo(\controller\Guilds::class);
$SideBar->Item('پذیرندگان', Fa::User_md())->LinksTo(\controller\Providers::class);
$SideBar->Item('کاربران', Fa::Users())->_items([
    MenuItem::create('کاربران آنیکارت', Fa::User_circle())->LinksTo(\controller\Users::class),
    MenuItem::create('تایید احراز هویت', Fa::User_circle())->LinksTo(\controller\Users::RelPath([], 'authenticate')),
    MenuItem::create('درخواست های برداشت اعتبار', Fa::Money())->LinksTo(\controller\WithdrawRequests::class),
    MenuItem::create('کد های تایید پیامک شده', Fa::Mobile())->LinksTo(\controller\UserTemp::class),
]);

$SideBar->Item('گزارش گیری', Fa::Line_chart())->_items([
    MenuItem::create('تراکنش های خرید (از پذیرندگان)', Fa::Exchange())->LinksTo(\controller\Transaction::class),
    MenuItem::create('گزارش مشکل', Fa::Times_circle())->LinksTo(\controller\Reports::class),
]);
$SideBar->Item('تنظیمات', Fa::Wrench())->_items([
    MenuItem::create('کد کارت های کاربران', Fa::Sort_alpha_asc())->LinksTo(\controller\Codes::class),
    MenuItem::create('فروش حضوری', Fa::Check_circle_o())->LinksTo(\controller\Codes::RelPath([], 'Inperson')),

    MenuItem::create('تخفیف ها', Fa::Percent())->LinksTo(\controller\Discounts::class),
    MenuItem::create('گزارش استفاده از تخفیف ها', Fa::Cc_discover())->LinksTo(\controller\DiscountUses::class),
    MenuItem::create('تنظیمات عمومی', Fa::Wrench())->LinksTo(\controller\Settings::class),
    MenuItem::create('فایل منیجر', Fa::Folder())->LinksTo(\controller\Files::class),
]);

$SideBar->Item('مدیریت اعلان ها، تیکت ها و نظرات', Fa::Sticky_note())->_items([
    MenuItem::create('نوتیفیکیشن ها', Fa::Envelope_open())->LinksTo(\controller\Notifications::class),
    MenuItem::create('نظرات کاربران', Fa::Comments())->LinksTo(\controller\Comments::class),
    MenuItem::create('گزارشات کاربران', Fa::Pie_chart()),
    MenuItem::create('کلمات ممنوعه', Fa::Hashtag())->LinksTo(\controller\BadWords::class),
    MenuItem::create('مدیریت تیکت ها', Fa::Envelope_open())->LinksTo(\controller\Tickets::class),
    MenuItem::create('دسته بندی تیکت ها', Fa::List())->LinksTo(\controller\TicketCategories::class),
    MenuItem::create('ایمیل های خبرنامه', Fa::Google())->LinksTo(\controller\Emails::class),

]);
$SideBar->Item('مدیریت محتوا', Fa::Internet_explorer())->_items([
    MenuItem::create('اشتراک ها', Fa::List())->LinksTo(\controller\Plans::class),
    MenuItem::create('متن صفحه اصلی وبسایت', Fa::List())->LinksTo(\controller\HomeSection::class),
    MenuItem::create('صفحه خوش آمدگویی', Fa::Pagelines())->LinksTo(\controller\WelcomePage::class),
    MenuItem::create('صفحه خرید اشتراک', Fa::Money())->LinksTo(\controller\PlanPage::class),
    MenuItem::create('شرکت های همکار', Fa::Building())->LinksTo(\controller\Companies::class),
    MenuItem::create('سوالات متداول', Fa::Question())->LinksTo(\controller\Faqs::class),
    MenuItem::create('شبکه های اجتماعی (فوتر وبسایت)', Fa::Instagram())->LinksTo(\controller\Socials::class),
    MenuItem::create('درباره ما (اپلیکیشن)', Fa::Address_book())->LinksTo(\controller\AppAboutUs::class),
    MenuItem::create('درباره ما (سایت)', Fa::Address_book())->LinksTo(\controller\AboutUs::class),
    MenuItem::create('تماس با ما', Fa::Phone())->LinksTo(\controller\ContactUs::class),
    MenuItem::create('چرا آنیکارت', Fa::Question_circle_o())->LinksTo(\controller\WhyUs::class),
    MenuItem::create('قوانین و مقررات', Fa::Gavel())->LinksTo(\controller\Rules::class),
    MenuItem::create('فرصت های شغلی', Fa::Laptop())->LinksTo(\controller\Jobs::class),
    MenuItem::create('درخواست های شغلی', Fa::Hand_paper_o())->LinksTo(\controller\JobRequests::class),
    MenuItem::create('ورژن اپلیکیشن کاربر ', Fa::Android())->LinksTo(\controller\AppVersions::class),
    MenuItem::create('ورژن اپلیکیشن پذیرنده ', Fa::Android())->LinksTo(\controller\ProviderAppVersions::class),

]);

$SideBar->Item('مدیریت بنر ها و اسلایدر ها', Fa::File_image_o())->_items([
    MenuItem::create('بنر های اصلی وبسایت', Fa::Picture_o())->LinksTo(\controller\TopBanners::class),
    MenuItem::create('بنرهای بالای صفحه اصلی', Fa::Picture_o())->LinksTo(\controller\SecondaryTopBanners::class),
    MenuItem::create('بنر های وسط صفحه اصلی', Fa::Picture_o())->LinksTo(\controller\MiddleBanners::class),
    MenuItem::create('اسلایدرها', Fa::Sliders())->LinksTo(\controller\Sliders::class),
]);
$SideBar->Item('آنیکلاب', Fa::Mobile())->_items([
    MenuItem::create('امتیاز های کاربران', Fa::Plus_circle())->LinksTo(\controller\Points::class),
    MenuItem::create('سیستم امتیازدهی ثابت', Fa::Wrench())->LinksTo(\controller\Scores::class),
    MenuItem::create('سیستم امتیازدهی روزانه', Fa::Sun_o())->LinksTo(\controller\DailyPoints::class),
    MenuItem::create('دسته بندی جوایز', Fa::List())->LinksTo(\controller\RewardCategories::class),
    MenuItem::create('جوایز', Fa::Gift())->LinksTo(\controller\Rewards::class),
]);

$SideBar->Item("بخش وبلاگ", Fa::Newspaper_o())->_items([
    MenuItem::create('مدیریت وبلاگ ها', Fa::Hacker_news())->LinksTo(\controller\Blogs::class),
    MenuItem::create('برچسب ها', Fa::Tags())->LinksTo(\controller\BlogTags::class),
    MenuItem::create('دسته بندی ها', Fa::List())->LinksTo(\controller\BlogCategories::class),
    MenuItem::create('نظرات', Fa::Comment())->LinksTo(\controller\BlogComments::class),
]);


if (UserObject::RoleName() == 'DeveloperRole') {
    $SideBar->Item('Tools', Fa::Wrench())->_items([
        MenuItem::create('QUERY BUILDER', Fa::Times_circle_o())
            ->LinksTo('QueryBuilder/QueryBuilder.fwTools'),
        MenuItem::create('MODEL GENERATOR', Fa::Times_circle_o())
            ->LinksTo('modelGenerator/modelGenerator.fwTools'),
        MenuItem::create('Form Generator', Fa::Times_circle_o())
            ->LinksTo('formGenerator/formGenerator.fwTools'),
        MenuItem::create('Data seeder', Fa::Times_circle_o())
            ->LinksTo('DataSeeder/DataSeeder.fwTools'),
    ]);
}

$SideBar->render();
