<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class AdTimesMigration extends Migratable {
    const modelName = 'AdTimes';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('ad_time_id');
			$blueprint->Int('ad_time_from')->Len(150);
			$blueprint->Int('ad_time_to')->Len(150);
			$blueprint->Int('ad_time_price')->Len(150);
			$blueprint->Int('ad_id')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
