<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class PrizesMigration extends Migratable {
    const modelName = 'Prizes';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('prize_id');
			$blueprint->VarChar('prize_name')->Len(150);
			$blueprint->VarChar('prize_image')->Len(150);
			$blueprint->Text('prize_details');
			$blueprint->Int('prize_count')->Len(150);
			$blueprint->Int('lottery_id')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
