<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class WorkersMigration extends Migratable {
    const modelName = 'Workers';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('worker_id');
			$blueprint->VarChar('worker_name')->Len(150);
			$blueprint->VarChar('worker_pic')->Len(150);
			$blueprint->Text('worker_details');
			$blueprint->VarChar('worker_email')->Len(150);
			$blueprint->VarChar('worker_password')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
