<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class DiscountsMigration extends Migratable {
    const modelName = 'Discounts';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('discount_id');
			$blueprint->VarChar('discount_code')->Len(150);
			$blueprint->Int('user_id')->Len(150);
			$blueprint->VarChar('discount_percent')->Len(150);
			$blueprint->VarChar('discount_expire_date')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
