<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class Scores extends View {

    public $SingularName = 'امتیاز';

    public function main(Document &$document) {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                                                                 ->Content(
                                                                     HtmlTags::Div('.row')
                                                                             ->Content(
                                                                                 HtmlTags::Div('.col-md-12')->Content(
                                                                                     HtmlTags::Div('.card.card-primary.card-outline')
                                                                                             ->Content(
                                                                                                 HtmlTags::Div('.card-header')
                                                                                                         ->Content(
                                                                                                             $this->Html()->CardTitle(),
                                                                                                             $this->Html()->refresh()
                                                                                                         ),
                                                                                                 HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                                                                                         ->Content(
                                                                                                             HtmlTags::Table('.table.table-bordered.table-striped')
                                                                                                                     ->Content(
                                                                                                                         HtmlTags::Thead('.table-dark')
                                                                                                                                 ->Content(
                                                                                                                                     HtmlTags::Tr()->Content(
                                                                                                                                         HtmlTags::Th('ردیف')->Width('50'),
                                                                                                                                         HtmlTags::Th('کد'),
                                                                                                                                         HtmlTags::Th('نام'),
                                                                                                                                         HtmlTags::Th('سقف روزانه'),
                                                                                                                                         HtmlTags::Th('امتیاز'),
                                                                                                                                         HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                                                                                     )
                                                                                                                                 ),
                                                                                                                         HtmlTags::Tbody()
                                                                                                                                 ->Content(
                                                                                                                                     $this->show([
                                                                                                                                                     'score_id',
                                                                                                                                                     'score_name',
                                                                                                                                                     'daily_maximum' => function ($max) {
                                                                                                                                                         return $max == 0 ? "نامحدود" : "$max بار";
                                                                                                                                                     },
                                                                                                                                                     'score_point'
                                                                                                                                                 ],false)
                                                                                                                                 )
                                                                                                                     )
                                                                                                         )
                                                                                             )
                                                                                 )
                                                                             )
                                                                 );
    }

    public function addIndex(Document &$document) {
        $document->html = $this->Form();
    }

    public function Form() {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                                                      ->Content(
                                                          HtmlTags::Div('.row')
                                                                  ->Content(
                                                                      HtmlTags::Div('.col-md-12')->Content(
                                                                          HtmlTags::Div('.card.card-primary.card-outline')
                                                                                  ->Content(
                                                                                      HtmlTags::Div('.card-header')
                                                                                              ->Content(
                                                                                                  $this->Html()->CardTitle(),
                                                                                                  $this->Html()->refreshAndBack()
                                                                                              ),
                                                                                      $this->Html()->FormStart() .

                                                                                      $this->Html()->FormGroupStart(4) .
                                                                                      $this->Html()->Label('نام') .
                                                                                      $this->Html()->Input('score_name') .
                                                                                      $this->Html()->FormGroupEnd() .

                                                                                      $this->Html()->FormGroupStart(4) .
                                                                                      $this->Html()->Label('امتیاز') .
                                                                                      $this->Html()->Number('score_point', 'score_point') .
                                                                                      $this->Html()->FormGroupEnd() .
                                                                                      $this->Html()->FormGroupStart(4) .
                                                                                      $this->Html()->Label('سقف روزانه (0 برابر با نامحدود)') .
                                                                                      $this->Html()->Number('daily_maximum', 'daily_maximum') .
                                                                                      $this->Html()->FormGroupEnd() .
                                                                                      $this->Html()->FormGroupStart(4) .
                                                                                      $this->Html()->Label('تصویر') .
                                                                                      $this->Html()->ImgInput('score_image', 'score_image') .
                                                                                      $this->Html()->FormGroupEnd() .
                                                                                      $this->Html()->FormGroupStart(8) .
                                                                                      $this->Html()->Label('توضیحات') .
                                                                                      $this->Html()->TextArea('score_description', 'score_description') .
                                                                                      $this->Html()->FormGroupEnd() .
                                                                                      $this->Html()->CardFooter()
                                                                                  )
                                                                      )
                                                                  )
                                                      );
    }

    public function editIndex(Document &$document) {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document) {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document) {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        