<?
namespace view;
use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\FontAwesome;
use View;
class Tickets extends View
{

    public $SingularName = 'تیکت';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نام'),
                                                                    HtmlTags::Th('موبایل'),
                                                                    HtmlTags::Th('ایمیل'),
                                                                    HtmlTags::Th('متن'),
                                                                    HtmlTags::Th('تاریخ'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'name',
                                                                    'mobile',
                                                                    'email',
                                                                    'message',
                                                                    'created_at'=>function ($created) {
                                                                        return jdate("Y/m/d H:i", strtotime($created));

                                                                    },
                                                                ],true,false,false,true,function ($row){
                                                                    $checkAnswer = \model\Tickets::Db()->where('parent_id',$row->ticket_id);
                                                                    if ($checkAnswer->rowCount() == 0){
                                                                        return HtmlTags::A('.btn.btn-outline-secondary.p-2.answerTicket')->Content(
                                                                            HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Reply())
                                                                        )->Data_('id', $row->ticket_id)
                                                                            ->Data_('toggle', 'tooltip')
                                                                            ->Data_('placement', 'top')
                                                                            ->Title('پاسخ تیکت');
                                                                    }else{
                                                                        return HtmlTags::A('.btn.btn-outline-primary.p-2.showAnswer')->Content(
                                                                            HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Eye())
                                                                        )->Data_('id', $row->ticket_id)
                                                                            ->Data_('toggle', 'tooltip')
                                                                            ->Data_('placement', 'top')
                                                                            ->Title('نمایش پاسخ');
                                                                    }

                                                                })
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function Form()
    {
        return $this->Html()->BreadCrumbs() .HtmlTags::Section('.content')
    ->Content(
        HtmlTags::Div('.row')
            ->Content(
                HtmlTags::Div('.col-md-12')->Content(
                    HtmlTags::Div('.card.card-primary.card-outline')
                        ->Content(
                            HtmlTags::Div('.card-header')
                                ->Content(
                                    $this->Html()->CardTitle(),
                                    $this->Html()->refreshAndBack()
                                ),
                                    $this->Html()->FormStart().
                                      $this->Html()->FormGroupStart(6) .
                            $this->Html()->Label('نام') .
                            $this->Html()->Input('name') .
                            $this->Html()->FormGroupEnd() .

                            $this->Html()->FormGroupStart(6) .
                            $this->Html()->Label('موبایل') .
                            $this->Html()->Input('mobile') .
                            $this->Html()->FormGroupEnd() .

                            $this->Html()->FormGroupStart(6) .
                            $this->Html()->Label('ایمیل') .
                            $this->Html()->Input('email') .
                            $this->Html()->FormGroupEnd() .

                            $this->Html()->FormGroupStart(6) .
                            $this->Html()->Label('موضوع') .
                            $this->Html()->Select('ticket_category_id', 'ticket_category_id',  \model\TicketCategories::toOption()) .
                            $this->Html()->FormGroupEnd() .

                            $this->Html()->FormGroupStart(12) .
                            $this->Html()->Label('متن') .
                            $this->Html()->Input('message') .
                            $this->Html()->FormGroupEnd()  .
                                    $this->Html()->CardFooter()
                        )
                )
            )
    );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        