<?
namespace view;
use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;
class UserRewards extends View
{

    public $SingularName = 'دریافت های کاربر';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نوع (امتیاز/اعتبار)'),HtmlTags::Th('مقدار دریافت (اعتبار به تومان وارد گردد)'),HtmlTags::Th('علت'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show(['user_reward_type','user_reward_amount','user_reward_cause'])
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }
    
    public function Form()
    {
        return $this->Html()->BreadCrumbs() .HtmlTags::Section('.content')
    ->Content(
        HtmlTags::Div('.row')
            ->Content(
                HtmlTags::Div('.col-md-12')->Content(
                    HtmlTags::Div('.card.card-primary.card-outline')
                        ->Content(
                            HtmlTags::Div('.card-header')
                                ->Content(
                                    $this->Html()->CardTitle(),
                                    $this->Html()->refreshAndBack()
                                ),
                                    $this->Html()->FormStart().
                                      $this->Html()->FormGroupStart(3) .
                            $this->Html()->Label('نوع (امتیاز/اعتبار)') .
                            $this->Html()->Select('user_reward_type','user_reward_type',collect([HtmlTags::Option()->Value("امتیاز دریافتی")->Content("امتیاز دریافتی"),HtmlTags::Option()->Value("اعتبار دریافتی")->Content("اعتبار دریافتی")])->join('')) .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(3) .
                            $this->Html()->Label('مقدار دریافت (اعتبار به تومان وارد گردد)') .
                            $this->Html()->Input('user_reward_amount') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(3) .
                            $this->Html()->Label('علت') .
                            $this->Html()->Input('user_reward_cause') .
                            $this->Html()->FormGroupEnd()  .
                            $this->Html()->FormGroupStart(3) .
                            $this->Html()->Label('کاربر') .
                            $this->Html()->Select('user_id','user_id',\model\Users::toOption()) .
                            $this->Html()->FormGroupEnd()  .
                                    $this->Html()->CardFooter()
                        )
                )
            )
    );
    }
    
    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }
    
    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }
    
    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }
    
    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        